import java.net.*;
import java.io.*;
import java.util.*;
import java.security.*;
import javax.crypto.*;
import javax.crypto.spec.*;

public class Server{
	
//	>globale Variablen
	
	//>vernderbare Variablen
	
	final int MAXCLIENTS = 8;
	
	final static int PORT = 3000;
	
	//<vernderbare Variablen
	
	public static String ip;
	
	static int currentClients = 0;
	
	static NameTable table;
	
	static boolean done = false;
	
	static boolean listening = true;
	
	static long start;
	
	static long stop;
	
    static byte[] testKeyBits = { (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128 };

//	<globale Variablen
	
	public Server(){
		table = new NameTable();
	}
////////////////////////////////////////////////////////////////////////////////
	//Message Handling
////////////////////////////////////////////////////////////////////////////////
	void handleClient(Socket theClient){
		try{
			BufferedReader din = new BufferedReader(new InputStreamReader(theClient.getInputStream()));
			PrintWriter pout = new PrintWriter(theClient.getOutputStream());
			String getline = din.readLine();
			StringTokenizer st = new StringTokenizer(getline);
			String tag = st.nextToken();
			//insert clients
			if ((tag.equals("insert")) (&& done == false) && (listening == true)){
				String hname = st.nextToken();
				int port = Integer.parseInt(st.nextToken());
				int retValue = table.insert(hname, port);
				pout.println(retValue);
			}
			//give clients new keys
			else if ((tag.equals("keyRequest")) && (done == false) && (listening == false)){
				byte[] oldKey = { (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken(), (byte)st.nextToken() };
				byte[] newKey = getNextKeySet.gimmeNextKeySet(testKeyBits);
				try{
					for(int i = 0; i < testKeyBits.length(); i++){
						pout.println(ciphertext[i]);
					}
				}
				catch(IOException e){
					System.err.println(e);
				}
			}
			//when key is found, stop time and give quit signal
			else if ((tag.equals("keyFound")) && done == false)){
				stop = System.nanoTime();
				done = true;
			}
			//poisoning clients
			else if ((tag.equals("keyRequest")) && (done == true) && (listening == false)){
				pout.println("please commit suicide");
			}
			//just be happy when clients play lemmings;-)
			else if (tag.equals("suicideAccomplished")){
				System.out.println("The Client " + theClient + "just comitted suicide...")
			}
			pout.flush();
		}
		catch(IOException e){
			System.err.println(e);
		}
	}
////////////////////////////////////////////////////////////////////////////////	
	public static void main (String args[]) throws Exception{
		//crypto initializing
	    final byte[] keyBits = { (byte)-128, (byte)-128, (byte)127, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128 };
		final byte[] iVecBits = { (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128, (byte)-128 };
	    final Key key = new SecretKeySpec(keyBits, 0, keyBits.length, "AES"); 
	    Key testKey = new SecretKeySpec(testKeyBits, 0, testKeyBits.length, "AES");
	    IvParameterSpec iVec = null; 
	    iVec = new IvParameterSpec(iVecBits, 0, iVecBits.length); 
	    final String plainText = "abcdefghijklmnop";
	    final byte[] plainByteText = plainText.getBytes();
	    int blocksize = 16;
	    int ciphertextLength;  
	    int remainder = plainByteText.length % blocksize; 
	    if (remainder == 0) 
	        ciphertextLength = plainByteText.length; 
	      else 
	        ciphertextLength = plainByteText.length - remainder + blocksize; 
	    byte[] ciphertext = new byte[ciphertextLength]; 
	    Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
	    cipher.init(Cipher.ENCRYPT_MODE, key, iVec); 
	    cipher.doFinal(plainByteText, 0, plainByteText.length, ciphertext, 0); 
	    //crypto initialized
////////////////////////////////////////////////////////////////////////////////	    
		//getting own ip
		try{
			String test = (InetAddress.getLocalHost()).getHostName();
			ip = test;
			System.out.println("The Server is known as: "+ip);
		}
		catch (UnknownHostException e){
			System.err.println(e);
		}
		//waking up server
		Server ns = new Server();
		System.out.println("Nameserver started:");
		//listen for clients
		try{
			ServerSocket listener = new ServerSocket(PORT);
			while (MAXCLIENTS > currentClients){
				Socket aClient = listener.accept();
				ns.handleClient(aClient);
				aClient.close();
				currentClients++;
			}
			listening = false;
		}
		catch (IOException e){
			System.err.println("Server aborted:" + e);
		}
		//MAXLIENTS gathered in table(Guestbook full)
		//now tell everybody to go to work
		start = System.nanoTime();
		try{
			for(int i = 0; i < MAXCLIENTS; i++){
				Socket thisClient = new Socket(table.getHostName(i), table.getPort(i));
				PrintWriter pout = new PrintWriter(thisClient.getOutputStream());
				pout.println("start");
				for (int i = 0; i < ciphertext.length(); i++){
					pout.println(ciphertext[i]);
				}
				for (int i = 0; i < plainByteText.length(); i++){
					pout.println(plainByteText[i]);
				}
				pout.flush();
				System.out.println("Told Client "+table.getHostName(i)+" to go to work");
			}
		}
		catch(IOException e){
			System.err.println(e);
		}
		//everybody at work
		//wait for keyRequests
		try{
			ServerSocket listener = new ServerSocket(PORT);
			//if the key is not found yet
			while (done == false){
				Socket aClient = listener.accept();
				ns.handleClient(aClient);
				aClient.close();
			}
		}
		catch (IOException e){
			System.err.println("Server aborted:" + e);
		}
		//key was found, so kill all clients
		try{
			ServerSocket listener = new ServerSocket(PORT);
			while (currentClients > 0){
				Socket aClient = listener.accept();
				ns.handleClient(aClient);
				aClient.close();
			}
		}
		catch (IOException e){
			System.err.println("Server aborted:" + e);
		}
		long result = stop - start;
		System.out.println("The final Result is: " + result);
	}
}