-module(final).
-export([bang/0, start_client/0, client/10, start_server/0, server/10, 
	start_keyserver/0, keyserver/4]).
-import(getNextKeySet).
-import(getNextKey).
-author('nils.muellner@informatik.uni-oldenburg.de').
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%DISTRIBUTED ERLANG BENCHMARK								  %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%This is a distributed benchmark in Erlang.				  %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%To use it, follow these steps:							  %%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%1. alter Key in fun start_server()						  %%%%%%%%%%
%%%%%%%%%%2. alter Server_Node in funs								  %%%%%%%%%%
%%%%%%%%%%	2.a start_client() and									  %%%%%%%%%%
%%%%%%%%%%	2.b start_server() and									  %%%%%%%%%%
%%%%%%%%%%	2.c bang()												  %%%%%%%%%%
%%%%%%%%%%3. compile 												  %%%%%%%%%%
%%%%%%%%%%4. start erl-shell on server (erl -sname server)			  %%%%%%%%%%
%%%%%%%%%%	4.a start server (final:start_server().)				  %%%%%%%%%%
%%%%%%%%%%5. start erl-shell on server (erl -sname keyserver)		  %%%%%%%%%%
%%%%%%%%%%	5.a start keyserver (final:start_keyserver().)			  %%%%%%%%%%
%%%%%%%%%%6. start client-shells as you like (erl -sname client)	  %%%%%%%%%%
%%%%%%%%%%	6.a start clients (final:start_client().)				  %%%%%%%%%%
%%%%%%%%%%7. begin benchmark with bang on server-shell (final:bang().)%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
start_client() ->
	io:format("Starting Client.~n"),
	crypto:start(),
	Phase = 1,
	Server_Node = server@talona,
	Key_Server_Node = unknown,
	Iteration_Length = 257,
	Key_Set = <<16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,
		16#00,16#00,16#00,16#00,16#00,16#00>>,
	EnCipher = unset,
	DeCipher = unset,
	Text = unset,
	Real_Key = unset,
	IVec = unset,
	register(client, spawn(final, client, [Phase, Server_Node, Key_Server_Node,
	Iteration_Length, Key_Set, EnCipher, DeCipher, IVec, Real_Key, Text])).
client(Phase, Server_Node, Key_Server_Node, Iteration_Length, Key_Set, 
	EnCipher, DeCipher, IVec, Real_Key, Text) ->
	if 
		Phase == 1 ->
			io:format("Client started~n"),
			io:format("This Node is known as ~w.~n",[self()]),
			io:format("Initialization done. Leaving Phase 1.~n"),
			NextPhase = 2,
			client(NextPhase, Server_Node, Key_Server_Node, Iteration_Length,
				Key_Set, EnCipher, DeCipher, IVec, Real_Key, Text);
		Phase == 2 ->
			io:format("Phase 2 reached.~n"),
			io:format("connecting to server ~w.~n",[Server_Node]),
			{server, Server_Node} ! {client, self()},
			receive
				{server, New_Server_Node, New_Key_Server_Node, New_EnCipher, 
					New_DeCipher, New_IVec, New_Real_Key, New_Text} ->
					true
			end,
			NextPhase = 3,
			io:format("Leaving Phase 2.~n"),
			client(NextPhase, New_Server_Node, New_Key_Server_Node, 
				Iteration_Length, Key_Set, New_EnCipher, New_DeCipher, 
				New_IVec, New_Real_Key, New_Text);
		Phase == 3 ->
			io:format("Phase 3 reached.~n"),
			io:format("Awaiting Start Signal.~n"),
			receive
				{keyserver, New_Key_Server_Node} ->
					io:format("Started. Now Working. 
						Please be patient and wait!~n")
			end,
			NextPhase = 4,
			client(NextPhase, Server_Node, New_Key_Server_Node, 
				Iteration_Length, Key_Set, EnCipher, DeCipher, IVec, Real_Key, 
				Text);
		Phase == 4 ->
			if
				Iteration_Length > 255 ->
					Key_Server_Node ! {client, request, self()},
					receive
						{keyServer, New_Key_Set} ->
							true;
						kill ->
							crypto:stop(),
							io:format("Received Kill Signal.~n"),
							io:format("Client is going down.~n"),
							New_Key_Set = unset,
							exit(normal)
					end,
					New_Iteration_Length = 0;
				Iteration_Length < 256 ->
					<<Vek15,Vek14,Vek13,Vek12,Vek11,Vek10,Vek09,Vek08,Vek07,
						Vek06,Vek05,Vek04,Vek03,Vek02,Vek01,_>> = Key_Set,
					UsingKey = <<Vek15,Vek14,Vek13,Vek12,Vek11,Vek10,Vek09,
						Vek08,Vek07,Vek06,Vek05,Vek04,Vek03,Vek02,Vek01,
						Iteration_Length>>,
					New_Key_Set = Key_Set,
					TestCipher = crypto:aes_cbc_128_decrypt(UsingKey, IVec, 
						EnCipher),
					if
						TestCipher /= Text ->
							New_Iteration_Length = Iteration_Length +1;
						TestCipher == Text ->
							Server_Node ! {client, self(), found, UsingKey},
							New_Iteration_Length = Iteration_Length +1
					end
			end,
			client(Phase, Server_Node, Key_Server_Node, New_Iteration_Length, 
				New_Key_Set, EnCipher, DeCipher, IVec, Real_Key, Text)
	end.
start_server() ->
	Key = <<16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,
		16#00,16#00,16#00,16#00,16#00>>,
	IVec = <<16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,
		16#00,16#00,16#00,16#00,16#00>>,
	Text = "abcdefghijklmnop",
	crypto:start(),
	EnCipher = crypto:aes_cbc_128_encrypt(Key, IVec, Text),
	DeCipher = crypto:aes_cbc_128_decrypt(Key, IVec, EnCipher),
	io:format("Chiffre is ~w.~n",[EnCipher]),
	io:format("Cleartext is ~w.~n",[DeCipher]),
	Server_Node = server@talona,
	Key_Server_Node = keyserver@talona,
	Phase = 1,
	Start_Time = unset,
	Empty_User_List = [],
	crypto:stop(),
	register(server, spawn(final, server, 
		[Phase, Empty_User_List, EnCipher, DeCipher, IVec, Start_Time, 
			Server_Node, Key_Server_Node, Key, Text])).
server(Phase, User_List, EnCipher, DeCipher, IVec, Start_Time, Server_Node, 
	Key_Server_Node, Key, Text) ->
	if
		Phase == 1 ->
			io:format("Server successfully started~n"),	
			io:format("You are now in Phase 1~n"),
			NextPhase = 2,
			io:format("EnCipher:~w,~nDeCipher:~w,~nIVec:~w~n",
				[EnCipher, DeCipher, IVec]),
			io:format("Leaving Phase 1~n"),
			New_Text = list_to_binary(Text),
			server(NextPhase, User_List, EnCipher, DeCipher, IVec, Start_Time, 
				Server_Node, Key_Server_Node, Key, New_Text);
		Phase == 2 ->
			io:format("Server is in Phase 2 and awaiting Clients~n"),
			io:format("There are currently ~w Clients connected.~n",
				[length(User_List)]),
			io:format("EnCipher:~w,~nDeCipher:~w,~nIVec:~w~n",
				[EnCipher, DeCipher, IVec]),
			receive
				{client, Client_PID} ->
					io:format("Client ~w is connecting.~n", [Client_PID]),
					New_User_List = [{Client_PID}|User_List],
					Client_PID ! {server, self(), Key_Server_Node, EnCipher, 
						DeCipher, IVec, Key, Text},
					New_Start_Time = Start_Time,
					NextPhase = Phase;
				start ->
					{keyserver, Key_Server_Node} ! 
						{server, register, User_List},
					New_Start_Time = now(),
					io:format("Start-Signal received!~n"),
					io:format("Leaving Phase 2.~n"),
					NextPhase = 3,
					New_User_List = User_List
			end,
			server(NextPhase, New_User_List, EnCipher, DeCipher, IVec, 
				New_Start_Time, Server_Node, Key_Server_Node, Key, Text);
		Phase == 3 ->
			io:format("Server is in Phase 3 and awaiting result.~n"),
			io:format("EnCipher:~w,~nDeCipher:~w,~nIVec:~w~n",
				[EnCipher, DeCipher, IVec]),
			receive
				{client, Client_PID, found, Key} ->
					Stop_Time = now(),
					io:format("Key ~wwas found by ~w ~n",[Key, Client_PID]),
					{StartVekA,StartVekB,StartVekC} = Start_Time,
					{StopVekA,StopVekB,StopVekC} = Stop_Time,
					ResVekC = StopVekC - StartVekC,
					ResVekB = StopVekB - StartVekB,
					ResVekA = StopVekA - StartVekA,
					if
						ResVekC < 0 ->
							ResVekCNew = 
								ResVekC + 1000000,
							ResVekBNew = ResVekB - 1;
						true ->
							ResVekCNew = ResVekC,
							ResVekBNew = ResVekB
					end,
					if
						ResVekBNew < 0 ->
							ResVekBNewNew = 
								ResVekBNew + 1000000,
							ResVekANew = ResVekA - 1;
						true ->
							ResVekBNewNew = ResVekBNew,
							ResVekANew = ResVekA
					end,
					Result_Time = {ResVekANew,ResVekBNewNew,ResVekCNew},					
					io:format("alternatively ~w {megasecs, secs, milisecs}~n",
						[Result_Time]),
					io:format("Shutting down Keyserver.~n"),
					{keyserver, Key_Server_Node} ! kill,
					NextPhase = 4,
					io:format("Server is leaving Phase 4~n")
			end,
			server(NextPhase, User_List, EnCipher, DeCipher, IVec, Result_Time,
				Server_Node, Key_Server_Node, Key, Text);
		Phase == 4 ->
			io:format("Server is in Phase 4~n"),
			io:format("Final  Stage reached.~n"),
			io:format("Server is going down. Good Night.~n"),
			Start_Time,
			exit(normal)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
start_keyserver() ->
	Key = <<16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,16#00,
		16#00,16#00,16#00,16#00,16#00>>,
	User_List = unset,
	Length = unset,
	Phase = 1,
	register(keyserver, spawn(final, keyserver, 
		[Key, User_List, Phase, Length])).
keyserver(Key, User_List, Phase, Length) ->
	if
		Phase == 1 ->
			receive
				kill ->
					io:format("The Keyserver received a Kill-Signal.~n"),
					NewKey = Key,
					New_Length = length(User_List),
					New_User_List = User_List,
					New_Phase = 2;
				{server, register, New_User_List} ->
					NewKey = Key,
					lists:foreach(
						fun(Client_in_Brackets) -> 
							{Client} = Client_in_Brackets, 
							Client ! {keyserver, self()}
						end, 
						New_User_List),
					New_Length = Length,
					New_Phase = 1;
				{client, request, Client_PID}->
					%%%io:format("Sending Client ~w the new Key ~w.~n",
						[Client_PID, Key]),
					New_User_List = User_List,
					Client_PID ! {keyServer, Key},
					NewKey = getNextKeySet:getNextKey(Key),
					New_Phase = 1,
					New_Length = Length
			end,
			keyserver(NewKey, New_User_List, New_Phase, New_Length);
		Phase == 2 ->
			if
				Length == 0 ->
					io:format("All Clients killed ;-)~n"),
					New_Phase = 3;
				Length > 0 ->
					io:format("There are still ~w Clients to Shut Down.~n",
						[Length]),
					receive 
						{client, request, Client_PID} -> Client_PID ! kill,
							New_Phase = 2
					end
			end,
			New_Length = Length - 1,
			keyserver(Key, User_List, New_Phase, New_Length);
		Phase == 3 ->
			io:format("The Keyserver is going down!~n"),
			exit(normal)
	end.
bang() ->
	Server_Node = server@talona,
	{server, Server_Node} ! start.
