-author('nils.muellner@gmail.com').
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%																	   %%%%%
%%%%%	Redistribution and use in source and binary forms, with or without %%%%%
%%%%%	modification, are permitted provided that the following conditions %%%%%
%%%%%	are met:														   %%%%%
%%%%%																	   %%%%%
%%%%%	Redistributions of source code must retain the above copyright	   %%%%%
%%%%%	notice, this list of conditions and the following disclaimer.	   %%%%%
%%%%%																	   %%%%%
%%%%%	Redistributions in binary form must reproduce the above copyright  %%%%%
%%%%%	notice, this list of conditions and the following disclaimer in	   %%%%%
%%%%%	the documentation and/or other materials provided with the		   %%%%%
%%%%%	distribution.													   %%%%%
%%%%%																	   %%%%%
%%%%%	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND			   %%%%%
%%%%%	CONTRIBUTOR "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,		   %%%%%
%%%%%	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF		   %%%%%
%%%%%	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE		   %%%%%
%%%%%	DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE	   %%%%%
%%%%%	LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,   %%%%%
%%%%%	OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,		   %%%%%
%%%%%	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,	   %%%%%
%%%%%	OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON		   %%%%%
%%%%%	ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,	   %%%%%
%%%%%	OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY	   %%%%%
%%%%%	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE			   %%%%%
%%%%%	POSSIBILITY OF SUCH DAMAGE. 									   %%%%%
%%%%%																	   %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-define(accuracy,  0.1).                                        %% refer to manual section 4.2
-define(accuracy_field, [0,0,0,0,0,0,0,0,0,0]).                 %% refer to manual section 4.2
-define(accuracy_min_run_length, 100000).                       %% refer to manual section 4.2
-define(env, default).                                          %% defines the fault environment. v. 1.0 only delivers a static env named "default"
-define(exec_sem, 1).                                           %% execution semantics. please refer to section @@ in the thesis.
-define(fault_injector,{fault_injector,fault_injector@beshaba}).%% mandatory for communication. change the part after @ to hostname where fi runs.
-define(faulty_fault, 0).                                       %% representss the possibility, that a fault occurs which leads to a local legal state (not dynamic, appended before execution to nfp and efp)
-define(init_arbitrary, true).                                  %% if initial state in set of legal set of states, set false. for arbitrary initial states set to false.
-define(log_file, logged_events.log).                           %% name of the log-file
-define(logging, disable).                                      %% [enable, disable] if no logging is required, execution is faster if disabled
-define(scheduler_behav, static).                               %% [random, ordered, static] if random, a fair and safe waiting strategy is used. if ordered, nodes are calles according to their id and waiting-time.
-define(server, {server, server@beshaba}).                      %% mandatory for communication. change the part after @ to hostname where fserver runs.
-define(version, "1.0").                                        %% indicates the version displayed in the sim. length(version) == 3
-define(verbose, false).
                                                                %% [true, false, topology, client, sched]
                                                                    %% false     writes minimal output.
                                                                    %% true      writes every of below to console!
                                                                    %% topology  when asked for topology in initialization phase, the topologies are described, too.
                                                                    %% client    lets the client write current status for each step.
                                                                    %% sched     writes the selected node for each step. reasonable to check ordered ?scheduler_behav for example.
-define(tops,                                                   %% available topologies and algorithms
    [
        [square4,				%%level 1.1.1
         	[dfs, bfs],
         	{a,b},{b,a},
			{b,c},{c,b},
			{c,d},{d,c},
			{d,a},{a,d}],
        [maximal4,				%%level 1.2.1
         	[dfs, bfs],
         	{a,b},{b,a},
			{b,c},{c,b},
			{c,d},{d,c},
			{d,a},{a,d},
         	{a,c},{c,a},
         	{b,d},{d,a}],
		[serial_out4,			%%level 2.1.1
         	[dfs, bfs],
         	{a,b},{b,a},
			{b,c},{c,b},
			{c,d},{d,c}],
		[serial_in4,			%%level 2.1.2
         	[dfs, bfs],
         	{a,b},{b,a},
			{a,c},{c,a},
			{c,d},{d,c}],
		[star_out4,				%%level 2.2.1
         	[dfs, bfs],
         	{a,b},{b,a},
			{b,c},{c,b},
			{b,d},{d,b}],
		[star_in4,				%%level 2.2.2
         	[dfs, bfs],
         	{a,b},{b,a},
			{a,c},{c,a},
			{a,d},{d,a}],
		[angel_side4,			%%level 2.3.1
         	[dfs, bfs],
         	{a,b},{b,a},
         	{a,c},{c,a},
			{b,c},{c,b},
         	{b,d},{d,b},
			{c,d},{d,c}],
        [angel_center4,			%%level 2.3.2
         	[dfs, bfs],
         	{a,b},{b,a},
			{a,c},{c,a},
			{a,d},{d,a},
			{b,c},{c,b},
           	{d,c},{c,d}],
		[cone_top4,				%%level 3.1.1
         	[dfs, bfs],
         	{a,b},{b,a},
			{b,c},{c,b},
			{c,d},{d,c},
			{d,b},{b,d}],
		[cone_middle4,			%%level 3.1.2
         	[dfs, bfs],
         	{a,b},{b,a},
			{a,c},{c,a},
			{c,d},{d,c},
			{d,a},{a,d}],
        [cone_bottom4,			%%level 3.1.3
         	[dfs, bfs],
         	{a,b},{b,a},
			{b,c},{c,b},
			{b,d},{d,b},
			{d,a},{a,d}]
	]).
