-module(matrix_init_dfs).
-author('nils.muellner@gmail.com').
-export([client_data/1, server_data/2]).
-include("global_config.hrl").
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%                                                                     %%%%%
%%%%% Redistribution and use in source and binary forms, with or without  %%%%%
%%%%% modification, are permitted provided that the following conditions  %%%%%
%%%%% are met:                                                            %%%%%
%%%%%                                                                     %%%%%
%%%%% Redistributions of source code must retain the above copyright      %%%%%
%%%%% notice, this list of conditions and the following disclaimer.       %%%%%
%%%%%                                                                     %%%%%
%%%%% Redistributions in binary form must reproduce the above copyright   %%%%%
%%%%% notice, this list of conditions and the following disclaimer in     %%%%%
%%%%% the documentation and/or other materials provided with the          %%%%%
%%%%% distribution.                                                       %%%%%
%%%%%                                                                     %%%%%
%%%%% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND               %%%%%
%%%%% CONTRIBUTOR "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,          %%%%%
%%%%% INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF            %%%%%
%%%%% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE            %%%%%
%%%%% DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE        %%%%%
%%%%% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,    %%%%%
%%%%% OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,            %%%%%
%%%%% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,     %%%%%
%%%%% OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON         %%%%%
%%%%% ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,     %%%%%
%%%%% OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY      %%%%%
%%%%% OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE             %%%%%
%%%%% POSSIBILITY OF SUCH DAMAGE.                                         %%%%%
%%%%%                                                                     %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% {Name, NFP, PID, [{Child, EFP}], Status, Legal_State, Waiting_Time} %%%%%
%%%%% Step0 {b,a}                   -> {a,_,_,[{b,_}],_,_,_}              %%%%%
%%%%% Step1 {a,_,_,[{b,_}],_,_,_}   -> {a,NF,_,[{b,_}],_,_,_}             %%%%%
%%%%% Step2 {a,NF,_,[{b,_}],_,_,_}  -> {a,NF,_,[{b,EF}],_,_,_}            %%%%%
%%%%% Step3 {a,NF,_,[{b,EF}],_,_,_} -> {a,NF,_,[{b,EF}],_,LS,_}           %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
client_data(Topology)->
%%Step0
	Step0 = make_client_matrix1(Topology, []),
%%Step1
	io:format("%%%%% Do you want to use GLOBAL NFP? [y. / n.]:"),
	{_, GlobalNFP} = io:read(standard_io, '>'),
	if
		GlobalNFP == y; GlobalNFP == yes ->
			io:format("%%%%% Please enter GLOBAL NFP [0.000000. =< r =< 1.000000.]:"),
			{_, GlobalNFPVal} = io:read(standard_io, '>'),
			if
				GlobalNFPVal =< 1, GlobalNFPVal >= 0 ->
					io:format("%%%%% ACCEPTED                                                            %%%%%~n"),
					New_GlobalNFPVal = GlobalNFPVal * (1 - ?faulty_fault),
					Step1 = global_nf_faultify(Step0, New_GlobalNFPVal, []);
				true ->
					Step1 = false
			end;
		GlobalNFP == n; GlobalNFP == no ->
			Step1 = local_nf_faultify(Step0, []),
			io:format("%%%%% ACCEPTED                                                            %%%%%~n");
		true ->
			Step1 = false
	end,
	if
		Step1 == false ->
			io:format("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% INPUT FAILURE - IT WAS NOT ABLE TO INITIALIZE                       %%%%%
%%%%% STEP1 WITH THESE VALUES! TRY AGAIN!                                 %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n"),
			client_data(Topology);
%%Step2
		true ->
			io:format("%%%%% Do you want to use GLOBAL EFP? [y. / n.]:"),
			{_, GlobalEFP} = io:read(standard_io, '>'),
			if
				GlobalEFP == y; GlobalEFP == yes ->            
					io:format("%%%%% Please enter GLOBAL EFP [0.000000. =< r =< 1.000000.]:"),
					{_, GlobalEFPVal} = io:read(standard_io, '>'),
					if
						GlobalEFPVal =< 1, GlobalEFPVal >= 0 ->
							io:format("%%%%% ACCEPTED                                                            %%%%%~n"),
							New_GlobalEFPVal = GlobalEFPVal * (1 - ?faulty_fault),
							Step2 = global_ef_faultify(Step1, New_GlobalEFPVal, []);
						true ->
							Step2 = false
					end;
				GlobalEFP == n; GlobalEFP == no ->
					Step2 = local_ef_faultify(Step1, []),
					io:format("%%%%% ACCEPTED                                                            %%%%%~n");
				true ->
					Step2 = false
			end,
			if
				Step2 == false ->
					io:format("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% INPUT FAILURE - IT WAS NOT ABLE TO INITIALIZE                       %%%%%
%%%%% STEP2 WITH THESE VALUES! TRY AGAIN!                                 %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n"),
					client_data(Topology);
%%Step3
				true ->
					Step3 = legalize(Step2),
%%Finish
					{_, Result} = Step3,
					if
						?verbose == true; ?verbose == topology ->
							io:format("%%%%% Resulting Topology:
~p~n
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n", [Result]);
						true ->
							ok
					end,
					io:format("%%%%% Topology successfully initialized.                                  %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n"),
					Result
			end
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
server_data([], Return)->
	New_Return = lists:keysort(1, Return),
	New_Return;
server_data(Topology, Return)->
	[First| Rest] = Topology,
	{Name, _, _, _, Status, Legal_State, Waiting_Time} = First,
	New_First = {Name, Status, Legal_State, Waiting_Time},
	New_Return = lists:append(Return, [New_First]),
	server_data(Rest, New_Return).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%         NILS' LITTLE HELPER FUNCTIONS         %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
check_parent_elem(_, []) ->
    false;
check_parent_elem(Parent, Out) ->
	[First| Rest] = Out,
	{Name, _, _, _, _, _, _} = First,
	if
		Name == Parent ->
			true;
		true ->
			check_parent_elem(Parent, Rest)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_elem(Parent, Out) ->
    [First| Rest] = Out,
    {Name, _, _, _, _, _, _} = First,
    if
		Name == Parent ->
			First;
		true ->
			get_elem(Parent, Rest)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global_ef_faultify([], _, Faultified)->
	New_Faultified = lists:keysort(1, Faultified),
    New_Faultified;
global_ef_faultify(Step1, GlobalEFPVal, Faultified)->
	[First| Rest] = Step1,
	{Name, NF, PID, Children, Status, Legal_State, Waiting_Time} = First,
    New_Children = global_ef_faultify_children(Children , GlobalEFPVal, []),
	New_First = {Name, NF, PID, New_Children, Status, Legal_State, Waiting_Time},
	New_Faultified = lists:append(Faultified, [New_First]),
	global_ef_faultify(Rest, GlobalEFPVal, New_Faultified).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global_ef_faultify_children([], _, Return)->
    New_Return = lists:keysort(1, Return),
	New_Return;
global_ef_faultify_children(Children , GlobalEFPVal, Return)->
	[First| Rest] = Children,
	{Name, _} = First,
	New_First = {Name, GlobalEFPVal},
	New_Return = lists:append(Return, [New_First]),
	global_ef_faultify_children(Rest , GlobalEFPVal, New_Return).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global_nf_faultify([], _, Faultified)->
    New_Faultified = lists:keysort(1, Faultified),
    New_Faultified;
global_nf_faultify(Step0, GlobalNFPVal, Faultified)->
	[First| Rest] = Step0,
	{Name, _, PID, Children, Status, Legal_State, Waiting_Time} = First,
	New_First = {Name, GlobalNFPVal, PID, Children, Status, Legal_State, Waiting_Time},
	New_Faultified = lists:append(Faultified, [New_First]),
	global_nf_faultify(Rest, GlobalNFPVal, New_Faultified).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
legalize(Data)->
	My_Elem = get_elem(a, Data),
	{Name, Node_Fault, PID, Neighbours, Current, _, Wait} = My_Elem,
	New_My_Elem = {Name, Node_Fault, PID, Neighbours, Current, [a] , Wait},
	Rest_Matrix = lists:delete(My_Elem, Data),
	Stable_Matrix = [New_My_Elem],
	Path = [a],
	Iterative_List = [a],
	My_Children = legalize_get_children(Iterative_List, Data, a),
	[Next_Child|Other_Children] = My_Children,
	{Temp_Res_Matrix, _, List} = legalize(Next_Child, Path, Stable_Matrix, Rest_Matrix, Data, Iterative_List, Other_Children),
	[First, Second|Rest] = Temp_Res_Matrix,
	{Fi_Name,_,_,_,_,_,_} = First,
	{Se_Name,_,_,_,_,_,_} = Second,
	if
		Fi_Name == Se_Name ->
			Temp2_Res_Matrix = lists:append([First], Rest),
			Res_Matrix = lists:keysort(1,Temp2_Res_Matrix);
		true ->
			Res_Matrix = Temp_Res_Matrix
	end,
	{List, Res_Matrix}.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
legalize(My_Name, Path, Stable_Matrix, Rest_Matrix, Matrix, It_List, My_Siblings) ->
	My_Elem = get_elem(My_Name, Matrix),
	{Name, NFP, PID, Nei, Cur, _, Wait} = My_Elem,
	New_Path = lists:append(Path,[My_Name]),
	Stable_My_Elem = {Name, NFP, PID, Nei, Cur, New_Path, Wait},
	Bool = lists:member(Name, It_List),
	if
		Bool == true ->
			New_Stable_Matrix = Stable_Matrix;
		true ->
			New_Stable_Matrix = lists:append(Stable_Matrix, [Stable_My_Elem])
	end,
	New_Rest_Matrix = lists:delete(My_Elem, Rest_Matrix),
	New_It_List = lists:append(It_List,[My_Name]),
	Temp_My_Children = legalize_get_children(New_It_List, Matrix, My_Name),
	Strip_Stable_Matrix = legalize_strip_Matrix(New_Stable_Matrix,[]),
	My_Children = legalize_strip_old(Temp_My_Children,Strip_Stable_Matrix),
	if 
		length(New_Rest_Matrix) > 0 ->
			if
				length(My_Children) > 0 ->
					[Next_Child|Other_Children] = My_Children,
					{New_New_Stable_Matrix, New_New_Rest_Matrix, New_New_It_List} = legalize(Next_Child, New_Path, New_Stable_Matrix, New_Rest_Matrix, Matrix, New_It_List, Other_Children);
				true ->
					New_New_Stable_Matrix = New_Stable_Matrix,
					New_New_Rest_Matrix = New_Rest_Matrix,
					New_New_It_List = New_It_List
			end,
			if
				length(My_Siblings) > 0 ->
					[Next_Sibling|Other_Siblings] = My_Siblings,
					{New_New_New_Stable_Matrix, New_New_New_Rest_Matrix, New_New_New_It_List} = legalize(Next_Sibling, Path, New_New_Stable_Matrix, New_New_Rest_Matrix, Matrix, New_New_It_List, Other_Siblings);
				true ->
					New_New_New_Stable_Matrix = New_New_Stable_Matrix,
					New_New_New_Rest_Matrix = New_New_Rest_Matrix,
					New_New_New_It_List = New_New_It_List
			end,
			{New_New_New_Stable_Matrix,New_New_New_Rest_Matrix,New_New_New_It_List};
		true ->
			New_New_Stable_Matrix = lists:keysort(1,New_Stable_Matrix),
			{New_New_Stable_Matrix,[],New_It_List}
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
legalize_get_children(Iterative_List, Data, Name)->
    Raw_Neighbours = legalize_get_children_helper(Data, Name, []),
    legalize_rip_neighbours(Raw_Neighbours,Iterative_List).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
legalize_get_children_helper([], _, List)->
    lists:sort(List);
legalize_get_children_helper(Data, Name, List)->
    [First|Rest] = Data,
    {Node, _, _, Neighbours, _, _,_} = First,
    Raw_Neighbours = legalize_raw_neighbours(Neighbours,[]),
    Bool = lists:member(Name,Raw_Neighbours),
    if
    	Bool == true ->
            New_List = lists:append(List,[Node]);
        true ->
            New_List = List
    end,
    legalize_get_children_helper(Rest, Name, New_List).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
legalize_raw_neighbours([],Neighbours)->
    Neighbours;
legalize_raw_neighbours(List,Neighbours)->
    [First|Rest] = List,
    {Name,_} = First,
    New_Neighbours = lists:append(Neighbours,[Name]),
    legalize_raw_neighbours(Rest,New_Neighbours).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
legalize_rip_neighbours(Raw_Neighbours,[])->
    Raw_Neighbours;
legalize_rip_neighbours(Raw_Neighbours,Iterative_List)->
    [First|Rest] = Iterative_List,
    Bool = lists:member(First, Raw_Neighbours),
    if 
    	First == a ->
            New_Raw_Neighbours = Raw_Neighbours;
		true ->
			if
            	Bool ->
                    New_Raw_Neighbours = lists:delete(First, Raw_Neighbours);
                true ->
                    New_Raw_Neighbours = Raw_Neighbours
			end
	end,
	legalize_rip_neighbours(New_Raw_Neighbours,Rest).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
legalize_strip_Matrix([], Return) ->
	Return;
legalize_strip_Matrix(Matrix,Return) ->
	[First| Rest] = Matrix,
	{Name, _, _, _, _, _, _} = First,
	New_Return = lists:append([Name], Return),
	legalize_strip_Matrix(Rest, New_Return).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
legalize_strip_old(My_Children, []) ->
	My_Children;
legalize_strip_old(My_Children, Old_Elems) ->
	[First|Rest] = Old_Elems,
	Bool = lists:member(First,My_Children),
	if
		Bool == true ->
			New_My_Children = lists:delete(First,My_Children);
		true ->
			New_My_Children = My_Children
	end,
	legalize_strip_old(New_My_Children, Rest).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
local_ef_faultify([], Faultified)->
    New_Faultified = lists:keysort(2, Faultified),
	New_Faultified;
local_ef_faultify(Step1, Faultified)->
	[First| Rest] = Step1,
	{Name, NF, PID, Children, Status, Legal_State, Waiting_Time} = First,
    New_Children = local_ef_faultify_children(Name, Children , []),
	New_First = {Name, NF, PID, New_Children, Status, Legal_State, Waiting_Time},
	New_Faultified = lists:append(Faultified, [New_First]),
	local_ef_faultify(Rest, New_Faultified).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
local_ef_faultify_children(_, [], Faultified)->
    New_Faultified = lists:keysort(2, Faultified),
	New_Faultified;
local_ef_faultify_children(Parent, Children, Faultified)->
	[First| Rest] = Children,
	{Name, _} = First,
	io:format("%%%%%     Please enter EFP for edge 
%%%%%          [parent]<<<__~p__>>> [child]<<<__~p__>>>
%%%%%          [0.000000. =< r =< 1.000000.]:", [Parent, Name]),
	{_, LocalEFPVal} = io:read(standard_io, '>'),
	if
		LocalEFPVal =< 1, LocalEFPVal >= 0 ->
			io:format("%%%%% ACCEPTED                                                            %%%%%~n"),
			New_LocalEFPVal = LocalEFPVal * (1 - ?faulty_fault),
			New_Elem = {Name, New_LocalEFPVal},
			New_Faultified = lists:append(Faultified, [New_Elem]),
			local_ef_faultify_children(Parent, Rest, New_Faultified);
		true ->
			io:format("%%%%% REJECTED                                                            %%%%%~n"),
			local_ef_faultify_children(Parent, Children, Faultified)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
local_nf_faultify([], Faultified) ->
	New_Faultified = lists:keysort(1, Faultified),
	New_Faultified;
local_nf_faultify(Step0, Faultified) ->
	[First| Rest] = Step0,
	{Name, _, PID, Children, Status, Legal_State, Waiting_Time} = First,
	io:format("%%%%%     Please enter NFP for node <<<__~p__>>>
%%%%%          [0.000000. =< r =< 1.000000.]:", [Name]),
	{_, LocalNFPVal} = io:read(standard_io, '>'),
	if
		LocalNFPVal =< 1, LocalNFPVal >= 0 ->
			io:format("%%%%% ACCEPTED                                                            %%%%%~n"),
			New_LocalNFPVal = LocalNFPVal * (1 - ?faulty_fault),
			New_Elem = {Name, New_LocalNFPVal, PID, Children, Status, Legal_State, Waiting_Time},
			New_Faultified = lists:append(Faultified, [New_Elem]),
			local_nf_faultify(Rest, New_Faultified);
		true ->
			io:format("%%%%% REJECTED                                                            %%%%%~n"),
			local_nf_faultify(Step0, Faultified)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
make_client_matrix1([], Out)->
	New_Out = lists:sort(Out),
	New_Out;
make_client_matrix1(In, Out)->
	[First| Rest] = In,
	{Child, Parent} = First,
	Check_Parent_Elem = check_parent_elem(Parent, Out),
	if
		Check_Parent_Elem == false ->
			New_Elem = {Parent, nodefault, pid, [{Child, edgefault}], status, legal_state, waiting_time},
			New_Out = lists:append(Out, [New_Elem]);
		true ->
			Elem = get_elem(Parent, Out),
			{Name, Nodefault, PID, Children, Status, Legal_State, Waiting_Time} = Elem,
			New_Children = lists:append(Children, [{Child, edgefault}]),
			New_Elem = {Name, Nodefault, PID, New_Children, Status, Legal_State, Waiting_Time},
			Temp_Out = lists:delete(Elem, Out),
			New_Out = lists:append(Temp_Out, [New_Elem])
	end,
	make_client_matrix1(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%