-module(fault_injector_bfs).
-author('nils.muellner@gmail.com').
-export([gen_fault/2]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%																	   %%%%%
%%%%%	Redistribution and use in source and binary forms, with or without %%%%%
%%%%%	modification, are permitted provided that the following conditions %%%%%
%%%%%	are met:														   %%%%%
%%%%%																	   %%%%%
%%%%%	Redistributions of source code must retain the above copyright	   %%%%%
%%%%%	notice, this list of conditions and the following disclaimer.	   %%%%%
%%%%%																	   %%%%%
%%%%%	Redistributions in binary form must reproduce the above copyright  %%%%%
%%%%%	notice, this list of conditions and the following disclaimer in	   %%%%%
%%%%%	the documentation and/or other materials provided with the		   %%%%%
%%%%%	distribution.													   %%%%%
%%%%%																	   %%%%%
%%%%%	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND			   %%%%%
%%%%%	CONTRIBUTOR "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,		   %%%%%
%%%%%	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF		   %%%%%
%%%%%	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE		   %%%%%
%%%%%	DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE	   %%%%%
%%%%%	LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,   %%%%%
%%%%%	OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,		   %%%%%
%%%%%	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,	   %%%%%
%%%%%	OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON		   %%%%%
%%%%%	ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,	   %%%%%
%%%%%	OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY	   %%%%%
%%%%%	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE			   %%%%%
%%%%%	POSSIBILITY OF SUCH DAMAGE. 									   %%%%%
%%%%%																	   %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
gen_fault(Data, Out) ->
	{Time1, Time2, Time3} = now(),
	random:seed(Time1, Time2, Time3),
	Length = length(Data),
	Random = random:uniform(Length),
	Elem = lists:nth(Random, Data),
	{Name, _, _, _, _, _, _} = Elem,
	New_Data = lists:delete(Elem, Data),
	New_Out = lists:append(Out, [Name]),
	if
		Length == Random ->
			New_Out;
		true ->
			gen_fault(New_Data, New_Out)
	end.