-module(matrix_init_mutex).
-author('nils.muellner@gmail.com').
-export([client_data/1, server_data/2]).
-include("global_config.hrl").
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%                                                                     %%%%%
%%%%% Redistribution and use in source and binary forms, with or without  %%%%%
%%%%% modification, are permitted provided that the following conditions  %%%%%
%%%%% are met:                                                            %%%%%
%%%%%                                                                     %%%%%
%%%%% Redistributions of source code must retain the above copyright      %%%%%
%%%%% notice, this list of conditions and the following disclaimer.       %%%%%
%%%%%                                                                     %%%%%
%%%%% Redistributions in binary form must reproduce the above copyright   %%%%%
%%%%% notice, this list of conditions and the following disclaimer in     %%%%%
%%%%% the documentation and/or other materials provided with the          %%%%%
%%%%% distribution.                                                       %%%%%
%%%%%                                                                     %%%%%
%%%%% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND               %%%%%
%%%%% CONTRIBUTOR "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,          %%%%%
%%%%% INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF            %%%%%
%%%%% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE            %%%%%
%%%%% DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE        %%%%%
%%%%% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,    %%%%%
%%%%% OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,            %%%%%
%%%%% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,     %%%%%
%%%%% OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON         %%%%%
%%%%% ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,     %%%%%
%%%%% OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY      %%%%%
%%%%% OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE             %%%%%
%%%%% POSSIBILITY OF SUCH DAMAGE.                                         %%%%%
%%%%%                                                                     %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% {Name, NFP, PID, [{Child, EFP}], Status, Legal_State, Waiting_Time} %%%%%
%%%%% Step0 {b,a}                   -> {a,_,_,[{b,_}],_,_,_}              %%%%%
%%%%% Step1 {a,_,_,[{b,_}],_,_,_}   -> {a,NF,_,[{b,_}],_,_,_}             %%%%%
%%%%% Step2 {a,NF,_,[{b,_}],_,_,_}  -> {a,NF,_,[{b,EF}],_,_,_}            %%%%%
%%%%% Step3 {a,NF,_,[{b,EF}],_,_,_} -> {a,NF,_,[{b,EF}],_,LS,_}           %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
client_data(Topology)->
%%Step0
	Step0 = make_client_matrix1(Topology, []),
%%Step1
	io:format("%%%%% Do you want to use GLOBAL NFP? [y. / n.]:"),
	{_, GlobalNFP} = io:read(standard_io, '>'),
	if
		GlobalNFP == y; GlobalNFP == yes ->
			io:format("%%%%% Please enter GLOBAL NFP [0.000000. =< r =< 1.000000.]:"),
			{_, GlobalNFPVal} = io:read(standard_io, '>'),
			if
				GlobalNFPVal =< 1, GlobalNFPVal >= 0 ->
					io:format("%%%%% ACCEPTED                                                            %%%%%~n"),
					New_GlobalNFPVal = GlobalNFPVal * (1 - ?faulty_fault),
					Step1 = global_nf_faultify(Step0, New_GlobalNFPVal, []);
				true ->
					Step1 = false
			end;
		GlobalNFP == n; GlobalNFP == no ->
			Step1 = local_nf_faultify(Step0, []),
			io:format("%%%%% ACCEPTED                                                            %%%%%~n");
		true ->
			Step1 = false
	end,
	if
		Step1 == false ->
			io:format("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% INPUT FAILURE - IT WAS NOT ABLE TO INITIALIZE                       %%%%%
%%%%% STEP1 WITH THESE VALUES! TRY AGAIN!                                 %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n"),
			client_data(Topology);
%%Step2
		true ->
			io:format("%%%%% Do you want to use GLOBAL EFP? [y. / n.]:"),
			{_, GlobalEFP} = io:read(standard_io, '>'),
			if
				GlobalEFP == y; GlobalEFP == yes ->            
					io:format("%%%%% Please enter GLOBAL EFP [0.000000. =< r =< 1.000000.]:"),
					{_, GlobalEFPVal} = io:read(standard_io, '>'),
					if
						GlobalEFPVal =< 1, GlobalEFPVal >= 0 ->
							io:format("%%%%% ACCEPTED                                                            %%%%%~n"),
							New_GlobalEFPVal = GlobalEFPVal * (1 - ?faulty_fault),
							Step2 = global_ef_faultify(Step1, New_GlobalEFPVal, []);
						true ->
							Step2 = false
					end;
				GlobalEFP == n; GlobalEFP == no ->
					Step2 = local_ef_faultify(Step1, []),
					io:format("%%%%% ACCEPTED                                                            %%%%%~n");
				true ->
					Step2 = false
			end,
			if
				Step2 == false ->
					io:format("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% INPUT FAILURE - IT WAS NOT ABLE TO INITIALIZE                       %%%%%
%%%%% STEP2 WITH THESE VALUES! TRY AGAIN!                                 %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n"),
					client_data(Topology);
%%Step3
				true ->
					Step3 = legalize(Step2),
					if
						?verbose == true ->
							io:format("%%%%% Step2 == ~n~p~n%%%%% Step3 == ~p~n",[Step2, Step3]);
						true ->
							ok
					end,
%%Finish
					Result = Step3,
					io:format("%%%%% Topology successfully initialized.                                  %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n"),
					Result
			end
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
server_data([], Return)->
	New_Return = lists:keysort(1, Return),
	New_Return;
server_data(Topology, Return)->
	[First| Rest] = Topology,
	{Name, _, _, _, Status, Legal_State, Waiting_Time} = First,
	New_First = {Name, Status, Legal_State, Waiting_Time},
	New_Return = lists:append(Return, [New_First]),
	server_data(Rest, New_Return).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%         NILS' LITTLE HELPER FUNCTIONS         %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
check_parent_elem(_, []) ->
    false;
check_parent_elem(Parent, Out) ->
	[First| Rest] = Out,
	{Name, _, _, _, _, _, _} = First,
	if
		Name == Parent ->
			true;
		true ->
			check_parent_elem(Parent, Rest)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_elem(Parent, Out) ->
    [First| Rest] = Out,
    {Name, _, _, _, _, _, _} = First,
    if
		Name == Parent ->
			First;
		true ->
			get_elem(Parent, Rest)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global_ef_faultify([], _, Faultified)->
	New_Faultified = lists:keysort(1, Faultified),
    New_Faultified;
global_ef_faultify(Step1, GlobalEFPVal, Faultified)->
	[First| Rest] = Step1,
	{Name, NF, PID, Children, Status, Legal_State, Waiting_Time} = First,
    New_Children = global_ef_faultify_children(Children , GlobalEFPVal, []),
	New_First = {Name, NF, PID, New_Children, Status, Legal_State, Waiting_Time},
	New_Faultified = lists:append(Faultified, [New_First]),
	global_ef_faultify(Rest, GlobalEFPVal, New_Faultified).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global_ef_faultify_children([], _, Return)->
    New_Return = lists:keysort(1, Return),
	New_Return;
global_ef_faultify_children(Children , GlobalEFPVal, Return)->
	[First| Rest] = Children,
	{Name, _} = First,
	New_First = {Name, GlobalEFPVal},
	New_Return = lists:append(Return, [New_First]),
	global_ef_faultify_children(Rest , GlobalEFPVal, New_Return).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global_nf_faultify([], _, Faultified)->
    New_Faultified = lists:keysort(1, Faultified),
    New_Faultified;
global_nf_faultify(Step0, GlobalNFPVal, Faultified)->
	[First| Rest] = Step0,
	{Name, _, PID, Children, Status, Legal_State, Waiting_Time} = First,
	New_First = {Name, GlobalNFPVal, PID, Children, Status, Legal_State, Waiting_Time},
	New_Faultified = lists:append(Faultified, [New_First]),
	global_nf_faultify(Rest, GlobalNFPVal, New_Faultified).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
legalize(Data)->
	Return = legalize_sub(Data, []),
	Return.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
legalize_sub([], Out)->
	New_Out = lists:keysort(1, Out),
	New_Out;
legalize_sub(In, Out)->
	[First| Rest] = In,
	{Name, NF, PID, New_Children, Status, _, Waiting_Time} = First,
	New_First = {Name, NF, PID, New_Children, Status, placeholder, Waiting_Time},
	New_Out = lists:append(Out, [New_First]),
	legalize_sub(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
local_ef_faultify([], Faultified)->
    New_Faultified = lists:keysort(2, Faultified),
	New_Faultified;
local_ef_faultify(Step1, Faultified)->
	[First| Rest] = Step1,
	{Name, NF, PID, Children, Status, Legal_State, Waiting_Time} = First,
    New_Children = local_ef_faultify_children(Name, Children , []),
	New_First = {Name, NF, PID, New_Children, Status, Legal_State, Waiting_Time},
	New_Faultified = lists:append(Faultified, [New_First]),
	local_ef_faultify(Rest, New_Faultified).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
local_ef_faultify_children(_, [], Faultified)->
    New_Faultified = lists:keysort(2, Faultified),
	New_Faultified;
local_ef_faultify_children(Parent, Children, Faultified)->
	[First| Rest] = Children,
	{Name, _} = First,
	io:format("%%%%%     Please enter EFP for edge 
%%%%%          [parent]<<<__~p__>>> [child]<<<__~p__>>>
%%%%%          [0.000000. =< r =< 1.000000.]:", [Parent, Name]),
	{_, LocalEFPVal} = io:read(standard_io, '>'),
	if
		LocalEFPVal =< 1, LocalEFPVal >= 0 ->
			io:format("%%%%% ACCEPTED                                                            %%%%%~n"),
			New_LocalEFPVal = LocalEFPVal * (1 - ?faulty_fault),
			New_Elem = {Name, New_LocalEFPVal},
			New_Faultified = lists:append(Faultified, [New_Elem]),
			local_ef_faultify_children(Parent, Rest, New_Faultified);
		true ->
			io:format("%%%%% REJECTED                                                            %%%%%~n"),
			local_ef_faultify_children(Parent, Children, Faultified)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
local_nf_faultify([], Faultified) ->
	New_Faultified = lists:keysort(1, Faultified),
	New_Faultified;
local_nf_faultify(Step0, Faultified) ->
	[First| Rest] = Step0,
	{Name, _, PID, Children, Status, Legal_State, Waiting_Time} = First,
	io:format("%%%%%     Please enter NFP for node <<<__~p__>>>
%%%%%          [0.000000. =< r =< 1.000000.]:", [Name]),
	{_, LocalNFPVal} = io:read(standard_io, '>'),
	if
		LocalNFPVal =< 1, LocalNFPVal >= 0 ->
			io:format("%%%%% ACCEPTED                                                            %%%%%~n"),
			New_LocalNFPVal = LocalNFPVal * (1 - ?faulty_fault),
			New_Elem = {Name, New_LocalNFPVal, PID, Children, Status, Legal_State, Waiting_Time},
			New_Faultified = lists:append(Faultified, [New_Elem]),
			local_nf_faultify(Rest, New_Faultified);
		true ->
			io:format("%%%%% REJECTED                                                            %%%%%~n"),
			local_nf_faultify(Step0, Faultified)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
make_client_matrix1([], Out)->
	New_Out = lists:sort(Out),
	New_Out;
make_client_matrix1(In, Out)->
	[First| Rest] = In,
	{Child, Parent} = First,
	Check_Parent_Elem = check_parent_elem(Parent, Out),
	if
		Check_Parent_Elem == false ->
			New_Elem = {Parent, nodefault, pid, [{Child, edgefault}], status, legal_state, waiting_time},
			New_Out = lists:append(Out, [New_Elem]);
		true ->
			Elem = get_elem(Parent, Out),
			{Name, Nodefault, PID, Children, Status, Legal_State, Waiting_Time} = Elem,
			New_Children = lists:append(Children, [{Child, edgefault}]),
			New_Elem = {Name, Nodefault, PID, New_Children, Status, Legal_State, Waiting_Time},
			Temp_Out = lists:delete(Elem, Out),
			New_Out = lists:append(Temp_Out, [New_Elem])
	end,
	make_client_matrix1(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%