-module(fault_injector).
-author('nils.muellner@gmail.com').
-export([start/0, fault_injector/1]).
-include("global_config.hrl").
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%																	   %%%%%
%%%%%	Redistribution and use in source and binary forms, with or without %%%%%
%%%%%	modification, are permitted provided that the following conditions %%%%%
%%%%%	are met:														   %%%%%
%%%%%																	   %%%%%
%%%%%	Redistributions of source code must retain the above copyright	   %%%%%
%%%%%	notice, this list of conditions and the following disclaimer.	   %%%%%
%%%%%																	   %%%%%
%%%%%	Redistributions in binary form must reproduce the above copyright  %%%%%
%%%%%	notice, this list of conditions and the following disclaimer in	   %%%%%
%%%%%	the documentation and/or other materials provided with the		   %%%%%
%%%%%	distribution.													   %%%%%
%%%%%																	   %%%%%
%%%%%	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND			   %%%%%
%%%%%	CONTRIBUTOR "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,		   %%%%%
%%%%%	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF		   %%%%%
%%%%%	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE		   %%%%%
%%%%%	DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE	   %%%%%
%%%%%	LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,   %%%%%
%%%%%	OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,		   %%%%%
%%%%%	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,	   %%%%%
%%%%%	OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON		   %%%%%
%%%%%	ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,	   %%%%%
%%%%%	OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY	   %%%%%
%%%%%	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE			   %%%%%
%%%%%	POSSIBILITY OF SUCH DAMAGE. 									   %%%%%
%%%%%																	   %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
start() ->
	io:format("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%                                                                     %%%%%
%%%%%                                SiSSDA                               %%%%%
%%%%%                                                                     %%%%%
%%%%%                                 v ~p                             %%%%%
%%%%%                                                                     %%%%%
%%%%%                                                                     %%%%%
%%%%%                  Welcome to the Simulator for                       %%%%%
%%%%%             Self-Stabilizing Distributed Algorithms                 %%%%%
%%%%%                                                                     %%%%%
%%%%%                           FAULT INJECTOR                            %%%%%
%%%%%                                                                     %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n",[?version]),
	Phase = init,
	{One, Two, Three} = now(),
	random:seed(One, Two, Three),
	register(fault_injector, spawn(fault_injector, fault_injector, [Phase])).

start(phase_1) ->
	register(fault_injector, spawn(fault_injector, fault_injector, [phase_1])).

fault_injector(Phase)->
	if
		Phase == init ->
			?server ! {fault_injector, connect},
			receive
				ack ->
					io:format("%%%%% FAULT-INJECTOR CONNECTED SUCCESSFULLY                               %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%
%%%%%      SYSTEM IS NOW RUNNING. PLEASE WAIT...
%%%%%
%%%%%~n")
			end,
			New_Phase = gen_arbitrary_val,
			fault_injector(New_Phase);
		Phase == gen_arbitrary_val ->
			receive
				{Algorithm, Client_Data} ->
					New_Client_Matrix = gen_arbitrary_val(Algorithm, Client_Data, Client_Data, []),
					if
						?init_arbitrary == true ->
							Sending = New_Client_Matrix;
						true ->
							Sending = stabilize(New_Client_Matrix, [])
					end,
					?server ! Sending,
					New_Phase = phase_1
			end,
			fault_injector(New_Phase);
		Phase == phase_1 ->
			receive
				kill ->
					New_Phase = kill;
				{update, Client_Data} ->
					New_Client_Data = update_server_matrix(Client_Data, []),
					?server ! {updated, New_Client_Data},
					New_Phase = Phase;
				{Algorithm, Data, Exec_Sem} ->
					if
						?scheduler_behav == random ->
							Step1 = increase_timer(Data, []),
							Step2 = choose_nodes_random(Step1, Exec_Sem, []),%%[b]
							Step3 = reset_approp_timers(Step1, Step2, []);
						?scheduler_behav == ordered ->
							{Step2, Step3} = choose_nodes_ordered(Data, Exec_Sem, [])%%[b]
					end,
					Step4 = faultify_nodes(Step2, Step3, [], Algorithm),
					if
						?verbose == sched; ?verbose == true ->
							io:format("%%%%% ~p~n", [Step2]);
						true ->
							ok
					end,
					?server ! {Step4, Step3},
					New_Phase = Phase
			end,
			fault_injector(New_Phase);
		Phase == kill ->
			?server ! {killed, fault_injector},
			io:format("%%%%% RECEIVED KILL SIGNAL. GOING DOWN                                    %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n"),
			exit(normal)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%         NILS' LITTLE HELPER FUNCTIONS         %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
aggregate_waitin_time([], Time)->
	Time;
aggregate_waitin_time(Step1, Time)->
	[First| Rest] = Step1,
	{_, _, _, _, _, _, Wait} = First,
	if
		Wait > 0 ->
			New_Time = Time + Wait;
		true ->
			New_Time = Time
	end,
	aggregate_waitin_time(Rest, New_Time).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
choose_node(Data, Random, Unchosen)->
	[First| Rest] = Data,
	{Name, _, _, _, _, _, Wait} = First,
	New_Random = Random - Wait,
	if
		New_Random < 1 ->
			Temp_Unchosen = lists:append(Rest, Unchosen),
			New_Unchosen = lists:keysort(1, Temp_Unchosen),
			{Name, New_Unchosen};
		true ->
			New_Unchosen = lists:append(Unchosen, [First]),
			choose_node(Rest, New_Random, New_Unchosen)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
choose_nodes_ordered(Data, Exec_Sem, Out)->
	{Elem, New_Data} = get_next_elem(Data),
	New_Out = lists:append(Out, Elem),
	if
		Exec_Sem == 1 ->
			{New_Out, New_Data};
		true ->
			New_Exec_Sem = Exec_Sem - 1,
			choose_nodes_ordered(New_Data, New_Exec_Sem, New_Out)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
choose_nodes_random(_, 0, Chosen) ->
	Chosen;
choose_nodes_random(Data, Counter, Chosen) ->
	Waiting_Time = aggregate_waitin_time(Data, 0),
	Random = random:uniform(Waiting_Time),
	{Chosen_One, Rest} = choose_node(Data, Random, []),
	New_Chosen = lists:append(Chosen, [Chosen_One]),
	choose_nodes_random(Rest, Counter -1, New_Chosen).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
faultify_neighs([], Out, _, _, _)->
	Out;
faultify_neighs(Neighs, Out, Data, Algorithm, Stab)->
	[First| Rest] = Neighs,
	{Name, EF} = First,
	Test = EF * 1000000,
	Random = random:uniform(1000000),
	if
		Random < Test ->
			Fault = gen_fault(Algorithm, Data),
			if
				Stab == Fault ->
					Fail = true;
				true ->
					Fail = false
			end,
			New_Out = lists:append(Out, [Fault]);
		true ->
			Elem = get_elem(Name, Data),
			Fail = false,
			{_, _, PID, _, _, _, _} = Elem,
			New_Out = lists:append(Out, [PID])
	end,
	if
		Fail == true ->
			faultify_neighs(Neighs, Out, Data, Algorithm, Stab);
		Fail == false ->
			faultify_neighs(Rest, New_Out, Data, Algorithm, Stab)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
faultify_nodes([], _, Out, _)->
	Out;
faultify_nodes(Exec_List, Data, Out, Algorithm)->
	[Name| Rest] = Exec_List,
	Elem = get_elem(Name, Data),
	{_, NF, PID, Neighs, _, Stab, _} = Elem,
	Test = NF * 1000000,
	Random = random:uniform(1000000),
	if
		Random < Test ->
			Fault = gen_fault(Algorithm, Data),
			if
				Fault == Stab ->
					Fail = true;
				true ->
					Fail = false
			end,
			New_Exec_Elem = {PID, {node_fault, Fault}};
		true ->
			Fail = false,
			Faulty_Neighs = faultify_neighs(Neighs, [], Data, Algorithm, Stab),
			New_Exec_Elem = {PID, {grant, Faulty_Neighs}}
	end,
	New_Out = lists:append(Out, [New_Exec_Elem]),
	if
		Fail == false ->
			faultify_nodes(Rest, Data, New_Out, Algorithm);
		Fail == true ->
			faultify_nodes(Exec_List, Data, Out, Algorithm)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
gen_arbitrary_val(_, [], _, Out)->
	Out;
gen_arbitrary_val(Algorithm, Client_Data, Static_Data, Out)->
	[First| Rest] = Client_Data,
	{Name, NFault, PID, Neighs, _, Stable, _} = First,
	New_Current_Value = gen_fault(Algorithm, Static_Data),
	New_Elem = {Name, NFault, PID, Neighs, New_Current_Value, Stable, 0},
	New_Out = lists:append(Out, [New_Elem]),
	gen_arbitrary_val(Algorithm, Rest, Static_Data, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
gen_fault(Algorithm, Data)->
	if
		Algorithm == bfs ->
			Fault = fault_injector_bfs:gen_fault(Data, []);
		Algorithm == dfs ->
			Fault = fault_injector_dfs:gen_fault(Data, []);
		Algorithm == le ->
			Fault = fault_injector_le:gen_fault(Data);
		Algorithm == mutex ->
			Fault = fault_injector_mutex:gen_fault(Data)
	end,
	Fault.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_elem(Name, Data)->
	[First| Rest] = Data,
	{Node, _, _, _, _, _, _} = First,
	if
		Node == Name ->
			First;
		true ->
			get_elem(Name, Rest)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_next_elem(Data)->
	Smallest_Index = get_next_elem_1(Data, []),
	{Old, New} = get_next_smallest_elem(Data, Smallest_Index),
	{Name, _, _, _, _, _, _} = New,
	Temp1_Data = lists:delete(Old, Data),
	Temp2_Data = lists:append(Temp1_Data, [New]),
	New_Data = lists:keysort(1, Temp2_Data),
	{[Name], New_Data}.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_next_elem_1([], Out)->
	[Step] = Out,
	Step;
get_next_elem_1(Data, Out)->
	[First| Rest] = Data,
	{_, _, _, _, _, _, Step} = First,
	if
		Out == [] ->
			New_Out = [Step];
		true ->
			[Last] = Out,
			if
				Last < Step ->
					New_Out = [Last];
				true ->
					New_Out = [Step]
			end
	end,
	get_next_elem_1(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_next_smallest_elem(Data, Smallest_Index)->
	[First| Rest] = Data,
	{Name, NFault, PID, Neighs, Current, Stable, Step} = First,
	if
		Step > Smallest_Index ->
			get_next_smallest_elem(Rest, Smallest_Index);
		true ->
			{Name, NFault, PID, Neighs, Current, Stable, Step} = First,
			New_Step = Step + 1,
			New_First = {Name, NFault, PID, Neighs, Current, Stable, New_Step},
			{First, New_First}
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
increase_timer([], Out)->
	Out;
increase_timer(Data, Out)->
	[First| Rest] = Data,
	{Name, NF, PID, Neighs, Cur, Stab, Wait} = First,
	New_Wait = Wait + 1,
	New_First = {Name, NF, PID, Neighs, Cur, Stab, New_Wait},
	New_Out = lists:append(Out, [New_First]),
	increase_timer(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
reset_approp_timers(Data, [], Out)->
	Temp_Out = lists:append(Out, Data),
	New_Out = lists:keysort(1, Temp_Out),
	New_Out;
reset_approp_timers(Data, List, Out)->
	[First| Rest] = List,
	Elem = get_elem(First, Data),
	New_Data = lists:delete(Elem, Data),
	{Name, NF, PID, Neighs, Cur, Stab, _} = Elem,
	New_Out = lists:append(Out, [{Name, NF, PID, Neighs, Cur, Stab, 0}]),
	reset_approp_timers(New_Data, Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
stabilize([], Out)->
	New_Out = lists:keysort(1, Out),
	New_Out;
stabilize(Client_Matrix, Out)->
	[First| Rest] = Client_Matrix,
	{Name, NFault, PID, Neighs, _, Stable, Step} = First,
	New_First = {Name, NFault, PID, Neighs, Stable, Stable, Step},
	New_Out = lists:append(Out, [New_First]),
	stabilize(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
update_server_matrix([], Out)->
	New_Out = lists:sort(Out),
	New_Out;
update_server_matrix(Client_Matrix, Out)->
	[First| Rest] = Client_Matrix,
	{Name, _, _, _, Status, Stable, Wait} = First,
	New_Elem = [Name, Status, Stable, Wait],
	New_Out = lists:append(Out, [New_Elem]),
	update_server_matrix(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%