-module(matrix_init_bfs).
-author('nils.muellner@gmail.com').
-export([client_data/1, server_data/2]).
-include("global_config.hrl").
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%                                                                     %%%%%
%%%%% Redistribution and use in source and binary forms, with or without  %%%%%
%%%%% modification, are permitted provided that the following conditions  %%%%%
%%%%% are met:                                                            %%%%%
%%%%%                                                                     %%%%%
%%%%% Redistributions of source code must retain the above copyright      %%%%%
%%%%% notice, this list of conditions and the following disclaimer.       %%%%%
%%%%%                                                                     %%%%%
%%%%% Redistributions in binary form must reproduce the above copyright   %%%%%
%%%%% notice, this list of conditions and the following disclaimer in     %%%%%
%%%%% the documentation and/or other materials provided with the          %%%%%
%%%%% distribution.                                                       %%%%%
%%%%%                                                                     %%%%%
%%%%% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND               %%%%%
%%%%% CONTRIBUTOR "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,          %%%%%
%%%%% INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF            %%%%%
%%%%% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE            %%%%%
%%%%% DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE        %%%%%
%%%%% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,    %%%%%
%%%%% OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,            %%%%%
%%%%% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,     %%%%%
%%%%% OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON         %%%%%
%%%%% ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,     %%%%%
%%%%% OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY      %%%%%
%%%%% OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE             %%%%%
%%%%% POSSIBILITY OF SUCH DAMAGE.                                         %%%%%
%%%%%                                                                     %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% {Name, NFP, PID, [{Child, EFP}], Status, Legal_State, Waiting_Time} %%%%%
%%%%% Step0 {b,a}                   -> {a,_,_,[{b,_}],_,_,_}              %%%%%
%%%%% Step1 {a,_,_,[{b,_}],_,_,_}   -> {a,NF,_,[{b,_}],_,_,_}             %%%%%
%%%%% Step2 {a,NF,_,[{b,_}],_,_,_}  -> {a,NF,_,[{b,EF}],_,_,_}            %%%%%
%%%%% Step3 {a,NF,_,[{b,EF}],_,_,_} -> {a,NF,_,[{b,EF}],_,LS,_}           %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
client_data(Topology)->
%%Step0
	Step0 = make_client_matrix1(Topology, []),
%%Step1
	io:format("%%%%% Do you want to use GLOBAL NFP? [y. / n.]:"),
	{_, GlobalNFP} = io:read(standard_io, '>'),
	if
		GlobalNFP == y ->
			io:format("%%%%% Please enter GLOBAL NFP [0.000000. =< r =< 1.000000.]:"),
			{_, GlobalNFPVal} = io:read(standard_io, '>'),
			if
				GlobalNFPVal =< 1, GlobalNFPVal >= 0 ->
					io:format("%%%%% ACCEPTED                                                            %%%%%~n"),
					New_GlobalNFPVal = GlobalNFPVal * (1 - ?faulty_fault),
					Step1 = global_nf_faultify(Step0, New_GlobalNFPVal, []);
				true ->
					Step1 = false
			end;
		GlobalNFP == n ->
			Step1 = local_nf_faultify(Step0, []),
			io:format("%%%%% ACCEPTED                                                            %%%%%~n");
		true ->
			Step1 = false
	end,
	if
		Step1 == false ->
			io:format("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% INPUT FAILURE - IT WAS NOT ABLE TO INITIALIZE                       %%%%%
%%%%% STEP1 WITH THESE VALUES! TRY AGAIN!                                 %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n"),
			client_data(Topology);
%%Step2
		true ->
			io:format("%%%%% Do you want to use GLOBAL EFP? [y. / n.]:"),
			{_, GlobalEFP} = io:read(standard_io, '>'),
			if
				GlobalEFP == y ->            
					io:format("%%%%% Please enter GLOBAL EFP [0.000000. =< r =< 1.000000.]:"),
					{_, GlobalEFPVal} = io:read(standard_io, '>'),
					if
						GlobalEFPVal =< 1, GlobalEFPVal >= 0 ->
							io:format("%%%%% ACCEPTED                                                            %%%%%~n"),
							New_GlobalEFPVal = GlobalEFPVal * (1 - ?faulty_fault),
							Step2 = global_ef_faultify(Step1, New_GlobalEFPVal, []);
						true ->
							Step2 = false
					end;
				GlobalEFP == n ->
					Step2 = local_ef_faultify(Step1, []),
					io:format("%%%%% ACCEPTED                                                            %%%%%~n");
				true ->
					Step2 = false
			end,
			if
				Step2 == false ->
					io:format("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% INPUT FAILURE - IT WAS NOT ABLE TO INITIALIZE                       %%%%%
%%%%% STEP2 WITH THESE VALUES! TRY AGAIN!                                 %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n"),
					client_data(Topology);
%%Step3
				true ->
					Stripped_Data = strip_data(Step2, []),
					Temp_Legalized_List = legalize_data(Stripped_Data, [a], 0, []),
					Legalized_List = denumerate(Temp_Legalized_List, []),
					Legalized_Data = merge(Legalized_List, Step2, [], []),
%%Finish
					Sorted_Legalized_Data = lists:keysort(1, Legalized_Data),
					if
						?verbose == true; ?verbose == topology ->
							io:format("%%%%% Resulting Topology:
~p~n
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n", [Sorted_Legalized_Data]);
						true ->
							ok
					end,
					io:format("%%%%% Topology successfully initialized.                                  %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n"),
					Sorted_Legalized_Data
			end
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
server_data([], Return)->
	New_Return = lists:keysort(1, Return),
	New_Return;
server_data(Topology, Return)->
	[First| Rest] = Topology,
	{Name, _, _, _, Status, Legal_State, Waiting_Time} = First,
	New_First = {Name, Status, Legal_State, Waiting_Time},
	New_Return = lists:append(Return, [New_First]),
	server_data(Rest, New_Return).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%         NILS' LITTLE HELPER FUNCTIONS         %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
check_parent_elem(_, []) ->
    false;
check_parent_elem(Parent, Out) ->
	[First| Rest] = Out,
	{Name, _, _, _, _, _, _} = First,
	if
		Name == Parent ->
			true;
		true ->
			check_parent_elem(Parent, Rest)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
denumerate([], Out)->
	Out2 = denumerate2(Out, []),
	Out2;
denumerate(Temp_Legalized_List, Out)->
	[_, List| Rest] = Temp_Legalized_List,
	New_Out = lists:append(Out, [List]),
	denumerate(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
denumerate2([], Out)->
	Out;
denumerate2(In, Out)->
	[First| Rest] = In,
	New_Out = lists:append(Out, First),
	denumerate2(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_children([], _, Return)->
	New_Return = minimize(Return, []),
	New_Return;
get_children(This_Generation, Static_List, Return)->
	[First| Rest] = This_Generation,
	Elem = get_small_elem(First, Static_List),
	{_, Children} = Elem,
	New_Return = lists:append(Return, [Children]),
	get_children(Rest, Static_List, New_Return).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_differ_nodes([], All_Nodes)->
	All_Nodes;
get_differ_nodes(Traverse, All_Nodes)->
	[First| Rest] = Traverse,
	New_All_Nodes = lists:delete(First, All_Nodes),
	get_differ_nodes(Rest, New_All_Nodes).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_eligible_children([], _, Out)->
	New_Out = lists:sort(Out),
	New_Out;
get_eligible_children(Temp_Next_Generation, Unset_Nodes, Out)->
	[First| Rest] = Temp_Next_Generation,
	Guard = lists:member(First, Unset_Nodes),
	if
		Guard == true ->
			New_Out = lists:append(Out, [First]);
		true ->
			New_Out = Out
	end,
	get_eligible_children(Rest, Unset_Nodes, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_elem(Parent, Out) ->
    [First| Rest] = Out,
    {Name, _, _, _, _, _, _} = First,
    if
		Name == Parent ->
			First;
		true ->
			get_elem(Parent, Rest)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_set_nodes([], Out)->
	New_Out = lists:sort(Out),
	New_Out;
get_set_nodes(In, Out)->
	[_, Nodes| Rest] = In,
	New_Out = lists:append(Out, Nodes),
	get_set_nodes(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_small_elem(Name, Static_List)->
	[First| Rest] = Static_List,
	{Node, _} = First,
	if
		Node == Name ->
			First;
		true ->
			get_small_elem(Name, Rest)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_stripped_all([], Out)->
	New_Out = lists:sort(Out),
	New_Out;
get_stripped_all(In, Out)->
	[First| Rest] = In,
	{Node, _} = First,
	New_Out = lists:append(Out, [Node]),
	get_stripped_all(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_unset_nodes(Return, Static_List, [])->
	Set_Nodes = get_set_nodes(Return, []),
	All_Nodes = get_stripped_all(Static_List, []),
	Unset_Nodes = get_differ_nodes(Set_Nodes, All_Nodes),
	Unset_Nodes.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global_ef_faultify([], _, Faultified)->
	New_Faultified = lists:keysort(1, Faultified),
    New_Faultified;
global_ef_faultify(Step1, GlobalEFPVal, Faultified)->
	[First| Rest] = Step1,
	{Name, NF, PID, Children, Status, Legal_State, Waiting_Time} = First,
    New_Children = global_ef_faultify_children(Children , GlobalEFPVal, []),
	New_First = {Name, NF, PID, New_Children, Status, Legal_State, Waiting_Time},
	New_Faultified = lists:append(Faultified, [New_First]),
	global_ef_faultify(Rest, GlobalEFPVal, New_Faultified).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global_ef_faultify_children([], _, Return)->
    New_Return = lists:keysort(1, Return),
	New_Return;
global_ef_faultify_children(Children , GlobalEFPVal, Return)->
	[First| Rest] = Children,
	{Name, _} = First,
	New_First = {Name, GlobalEFPVal},
	New_Return = lists:append(Return, [New_First]),
	global_ef_faultify_children(Rest , GlobalEFPVal, New_Return).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global_nf_faultify([], _, Faultified)->
    New_Faultified = lists:keysort(1, Faultified),
    New_Faultified;
global_nf_faultify(Step0, GlobalNFPVal, Faultified)->
	[First| Rest] = Step0,
	{Name, _, PID, Children, Status, Legal_State, Waiting_Time} = First,
	New_First = {Name, GlobalNFPVal, PID, Children, Status, Legal_State, Waiting_Time},
	New_Faultified = lists:append(Faultified, [New_First]),
	global_nf_faultify(Rest, GlobalNFPVal, New_Faultified).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
legalize_data(_, [], _, Return)->
	Return;
legalize_data(Static_List, This_Generation, Counter, Return)->
	New_Counter = Counter + 1,
	New_Return = lists:append(Return, [New_Counter, This_Generation]),
	Unset_Nodes = get_unset_nodes(New_Return, Static_List, []),
	Temp_Next_Generation = get_children(This_Generation, Static_List, []),
	Next_Generation = lists:sort(get_eligible_children(Temp_Next_Generation, Unset_Nodes, [])),
	legalize_data(Static_List, Next_Generation, New_Counter, New_Return).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
local_ef_faultify([], Return)->
    New_Return = lists:keysort(2, Return),
	New_Return;
local_ef_faultify(Step1, Faultified)->
	[First| Rest] = Step1,
	{Name, NF, PID, Children, Status, Legal_State, Waiting_Time} = First,
    New_Children = local_ef_faultify_children(Name, Children , []),
	New_First = {Name, NF, PID, New_Children, Status, Legal_State, Waiting_Time},
	New_Faultified = lists:append(Faultified, [New_First]),
	local_ef_faultify(Rest, New_Faultified).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
local_ef_faultify_children(_, [], Faultified)->
    New_Faultified = lists:keysort(2, Faultified),
	New_Faultified;
local_ef_faultify_children(Parent, Children, Faultified)->
	[First| Rest] = Children,
	{Name, _} = First,
	io:format("%%%%%     Please enter EFP for edge 
%%%%%          [parent]<<<__~p__>>> [child]<<<__~p__>>> [0.000000. =< r =< 1.000000.]:", [Parent, Name]),
	{_, LocalEFPVal} = io:read(standard_io, '>'),
	if
		LocalEFPVal =< 1, LocalEFPVal >= 0 ->
			io:format("%%%%% ACCEPTED                                                            %%%%%~n"),
			New_LocalEFPVal = LocalEFPVal * (1 - ?faulty_fault),
			New_Elem = {Name, New_LocalEFPVal},
			New_Faultified = lists:append(Faultified, [New_Elem]),
			local_ef_faultify_children(Parent, Rest, New_Faultified);
		true ->
			io:format("%%%%% REJECTED                                                            %%%%%~n"),
			local_ef_faultify_children(Parent, Children, Faultified)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
local_nf_faultify([], Faultified) ->
	New_Faultified = lists:keysort(1, Faultified),
	New_Faultified;
local_nf_faultify(Step0, Faultified) ->
	[First| Rest] = Step0,
	{Name, _, PID, Children, Status, Legal_State, Waiting_Time} = First,
	io:format("%%%%%     Please enter NFP for node <<<__~p__>>> [0.000000. =< r =< 1.000000.]:", [Name]),
	{_, LocalNFPVal} = io:read(standard_io, '>'),
	if
		LocalNFPVal =< 1, LocalNFPVal >= 0 ->
			io:format("%%%%% ACCEPTED                                                            %%%%%~n"),
			New_LocalNFPVal = LocalNFPVal * (1 - ?faulty_fault),
			New_Elem = {Name, New_LocalNFPVal, PID, Children, Status, Legal_State, Waiting_Time},
			New_Faultified = lists:append(Faultified, [New_Elem]),
			local_nf_faultify(Rest, New_Faultified);
		true ->
			io:format("%%%%% REJECTED                                                            %%%%%~n"),
			local_nf_faultify(Step0, Faultified)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
make_client_matrix1([], Out)->
	New_Out = lists:sort(Out),
	New_Out;
make_client_matrix1(In, Out)->
	[First| Rest] = In,
	{Child, Parent} = First,
	Check_Parent_Elem = check_parent_elem(Parent, Out),
	if
		Check_Parent_Elem == false ->
			New_Elem = {Parent, nodefault, pid, [{Child, edgefault}], status, legal_state, waiting_time},
			New_Out = lists:append(Out, [New_Elem]);
		true ->
			Elem = get_elem(Parent, Out),
			{Name, Nodefault, PID, Children, Status, Legal_State, Waiting_Time} = Elem,
			New_Children = lists:append(Children, [{Child, edgefault}]),
			New_Elem = {Name, Nodefault, PID, New_Children, Status, Legal_State, Waiting_Time},
			Temp_Out = lists:delete(Elem, Out),
			New_Out = lists:append(Temp_Out, [New_Elem])
	end,
	make_client_matrix1(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
merge([], [], Return, _)->
	Return;
merge(Nodes, Step2, Return, Value)->
	[First| Rest] = Nodes,
	Elem = get_elem(First, Step2),
	New_Step2 = lists:delete(Elem, Step2),
	New_Value = lists:append(Value, [First]),
	{Name, NF, PID, Neighs, Current, _, Wait} = Elem,
	New_Elem = {Name, NF, PID, Neighs, Current, New_Value, Wait},
	New_Return = lists:append(Return, [New_Elem]),
	merge(Rest, New_Step2, New_Return, New_Value).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
minimize([], Out) ->
	New_Out = lists:sort(Out),
	New_Out;
minimize(In, Out) ->
	[First| Rest] = In,
	New_Out = minimize_sub(First, Out),
    minimize(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
minimize_sub([], Out)->
	Out;
minimize_sub(List, Out)->
	[First| Rest] = List,
	Guard = lists:member(First, Out),
	if
		Guard == true ->
			New_Out = Out;
		true ->
			New_Out = lists:append(Out, [First])
	end,
	minimize_sub(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
strip_data([], Out)->
	New_Out = lists:keysort(1, Out),
	New_Out;
strip_data(Step2, Out)->
	[First| Rest] = Step2,
	{Name, _, _, Neighs, _, _, _} = First,
	New_Neighs = strip_data_sub(Neighs,[]),
	New_Out = lists:append(Out, [{Name, New_Neighs}]),
	strip_data(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
strip_data_sub([], Out)->
	New_Out = lists:sort(Out),
	New_Out;
strip_data_sub(Neighs, Out)->
	[First| Rest] = Neighs,
	{Name, _} = First,
	New_Out = lists:append(Out, [Name]),
	strip_data_sub(Rest, New_Out).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%