-author('nils.muellner@gmail.com').
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%																	   %%%%%
%%%%%	Redistribution and use in source and binary forms, with or without %%%%%
%%%%%	modification, are permitted provided that the following conditions %%%%%
%%%%%	are met:														   %%%%%
%%%%%																	   %%%%%
%%%%%	Redistributions of source code must retain the above copyright	   %%%%%
%%%%%	notice, this list of conditions and the following disclaimer.	   %%%%%
%%%%%																	   %%%%%
%%%%%	Redistributions in binary form must reproduce the above copyright  %%%%%
%%%%%	notice, this list of conditions and the following disclaimer in	   %%%%%
%%%%%	the documentation and/or other materials provided with the		   %%%%%
%%%%%	distribution.													   %%%%%
%%%%%																	   %%%%%
%%%%%	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND			   %%%%%
%%%%%	CONTRIBUTOR "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,		   %%%%%
%%%%%	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF		   %%%%%
%%%%%	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE		   %%%%%
%%%%%	DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE	   %%%%%
%%%%%	LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,   %%%%%
%%%%%	OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,		   %%%%%
%%%%%	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,	   %%%%%
%%%%%	OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON		   %%%%%
%%%%%	ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,	   %%%%%
%%%%%	OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY	   %%%%%
%%%%%	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE			   %%%%%
%%%%%	POSSIBILITY OF SUCH DAMAGE. 									   %%%%%
%%%%%																	   %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
-define(accuracy,  0.00001).                                          %% refer to manual section 4.2
-define(accuracy_field, [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]).                           %% refer to manual section 4.2
-define(accuracy_min_run_length, 1000).                         %% refer to manual section 4.2
-define(env, default).                                          %% defines the fault environment. v. 1.0 only delivers a static env named "default"
-define(exec_sem, 1).                                           %% execution semantics. please refer to section @@ in the thesis.
-define(fault_injector, {fault_injector,fault_injector@talona}). %% mandatory for communication. change the part after @ to hostname where fi runs.
-define(faulty_fault, 0).                                       %% representss the possibility, that a fault occurs which leads to a local legal state (not dynamic, appended before execution to nfp and efp)
-define(init_arbitrary, true).                                  %% if initial state in set of legal set of states, set false. for arbitrary initial states set to false.
-define(log_file, logged_events.log).                           %% name of the log-file
-define(logging, disable).                                      %% [enable, disable] if no logging is required, execution is faster if disabled
-define(scheduler_behav, random).                              %% [random, ordered] if random, a fair and safe waiting strategy is used. if ordered, nodes are calles according to their id and waiting-time.
-define(server, {server, server@talona}).                        %% mandatory for communication. change the part after @ to hostname where fserver runs.
-define(version, "1.0").                                        %% indicates the version displayed in the sim. length(version) == 3
-define(verbose, false).
                                                                %% [true, false, topology, client, sched]
                                                                    %% false     writes minimal output.
                                                                    %% true      writes every of below to console!
                                                                    %% topology  when asked for topology in initialization phase, the topologies are described, too.
                                                                    %% client    lets the client write current status for each step.
                                                                    %% sched     writes the selected node for each step. reasonable to check ordered ?scheduler_behav for example.
-define(tops,                                                   %% available topologies and algorithms
    [
		[serial8,
			[dfs, bfs, le],
			{a,b},{b,a},
			{b,c},{c,b},
			{c,d},{d,c},
			{d,e},{e,d},
			{e,f},{f,e},
			{f,g},{g,f},
			{g,h},{h,g}],
		[parallel8,
			[dfs, bfs, le],
			{a,b},{a,c},{a,d},{a,e},{a,f},{a,g},{a,h},
			{b,a},{c,a},{d,a},{e,a},{f,a},{g,a},{h,a}],
		[complex8,
			[dfs, bfs, le],
			{a,d},{a,e},
			{b,c},{b,e},
			{c,b},{c,d},{c,e},{c,g},{c,h},
			{d,a},{d,c},{d,e},{d,g},
			{e,a},{e,b},{e,c},{e,d},{e,g},{e,h},
			{f,g},{f,h},
			{g,c},{g,d},{g,e},{g,f},
			{h,c},{h,e},{h,f}],
		[ring8,
			[dfs, bfs, le, mutex],
			{b,a},{c,b},{d,c},{e,d},{f,e},{g,f},{h,g},{a,h}]
	]).
