-module(client_algorithm_mutex).
-author('nils.muellner@gmail.com').
-export([start/3]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%                                                                     %%%%%
%%%%% Redistribution and use in source and binary forms, with or without  %%%%%
%%%%% modification, are permitted provided that the following conditions  %%%%%
%%%%% are met:                                                            %%%%%
%%%%%                                                                     %%%%%
%%%%% Redistributions of source code must retain the above copyright      %%%%%
%%%%% notice, this list of conditions and the following disclaimer.       %%%%%
%%%%%                                                                     %%%%%
%%%%% Redistributions in binary form must reproduce the above copyright   %%%%%
%%%%% notice, this list of conditions and the following disclaimer in     %%%%%
%%%%% the documentation and/or other materials provided with the          %%%%%
%%%%% distribution.                                                       %%%%%
%%%%%                                                                     %%%%%
%%%%% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND               %%%%%
%%%%% CONTRIBUTOR "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,          %%%%%
%%%%% INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF            %%%%%
%%%%% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE            %%%%%
%%%%% DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE        %%%%%
%%%%% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,    %%%%%
%%%%% OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,            %%%%%
%%%%% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,     %%%%%
%%%%% OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON         %%%%%
%%%%% ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,     %%%%%
%%%%% OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY      %%%%%
%%%%% OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE             %%%%%
%%%%% POSSIBILITY OF SUCH DAMAGE.                                         %%%%%
%%%%%                                                                     %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%In: [3], a, Data
%%Out: [4] %%n >= 5
%%Out: [0] %%n < 3
start(In, Name, Data) ->
%	io:format("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%                                                                     %%%%%
%%%%%                                                                     %%%%%
%~n~n~nIn = ~p~n Name = ~p~n Data = ~p~n", [In, Name, Data]),
	Size = length(Data),
	My_Elem = get_elem(Name, Data),
	{_, _, _, _, Current, _, _} = My_Elem,
	[N_minus_1_temp] = In,
	Bool = is_integer(N_minus_1_temp),
	if
		Bool == true ->
			N_minus_1 = N_minus_1_temp;
		true ->
			N_minus_1 = Current
	end,
	if
		Name == a ->
			if
				N_minus_1 == Current->
					New_Current = (Current + 1) rem (Size + 1);
				true ->
					New_Current = Current
			end;
		true ->
			if
				N_minus_1 /= Current->
					New_Current = N_minus_1;
				true ->
					New_Current = Current
			end
	end,
%	io:format("%%%%% Old Val:~p~nPrevious' Elem Value: ~p~nSo new Val:~p~n
%%%%%                                                                     %%%%%
%%%%%                                                                     %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n", [Current, N_minus_1, New_Current]),
	New_Current.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%         NILS' LITTLE HELPER FUNCTIONS         %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_elem(Name, Data)->
	[First| Rest] = Data,
	{Node, _, _, _, _, _, _} = First,
	if
		Node == Name ->
			First;
		true ->
			get_elem(Name, Rest)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%