-module(client_algorithm_le).
-author('nils.muellner@gmail.com').
-export([start/3]).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%                                                                     %%%%%
%%%%% Redistribution and use in source and binary forms, with or without  %%%%%
%%%%% modification, are permitted provided that the following conditions  %%%%%
%%%%% are met:                                                            %%%%%
%%%%%                                                                     %%%%%
%%%%% Redistributions of source code must retain the above copyright      %%%%%
%%%%% notice, this list of conditions and the following disclaimer.       %%%%%
%%%%%                                                                     %%%%%
%%%%% Redistributions in binary form must reproduce the above copyright   %%%%%
%%%%% notice, this list of conditions and the following disclaimer in     %%%%%
%%%%% the documentation and/or other materials provided with the          %%%%%
%%%%% distribution.                                                       %%%%%
%%%%%                                                                     %%%%%
%%%%% THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND               %%%%%
%%%%% CONTRIBUTOR "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,          %%%%%
%%%%% INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF            %%%%%
%%%%% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE            %%%%%
%%%%% DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE        %%%%%
%%%%% LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,    %%%%%
%%%%% OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,            %%%%%
%%%%% PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,     %%%%%
%%%%% OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON         %%%%%
%%%%% ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,     %%%%%
%%%%% OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY      %%%%%
%%%%% OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE             %%%%%
%%%%% POSSIBILITY OF SUCH DAMAGE.                                         %%%%%
%%%%%                                                                     %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%In: [[1,a],[1,b],[2,a]], []
%%Out: [2,a]
start(In, Out, Name) ->
	[First| Rest] = In,
	Length = length(Rest),
	if
		Out == [] ->
			New_Out = First;
		true ->
			[New_Dist, New_Root] = First,
			[Old_Dist, Old_Root] = Out,
			if
				New_Root < Old_Root ->
					New_Out = First;
				New_Root > Old_Root ->
					New_Out = Out;
				true ->
					if
						New_Dist < Old_Dist ->
							New_Out = First;
						New_Dist > Old_Dist ->
							New_Out = Out;
						true ->
							New_Out = Out
					end
			end
	end,
	if
		Length == 0 ->
			if
				Name == a ->
					New_New_Out = [0,a];
				true ->
					[Dist, Root] = New_Out,
					New_New_Out = [Dist + 1, Root]
			end,
			New_New_Out;
		true ->
			start(Rest, New_Out, Name)
	end.
