-module(client).
-author('nils.muellner@gmail.com').
-export([start/0, start/1, client/7]).
-include("global_config.hrl").
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%																	   %%%%%
%%%%%	Redistribution and use in source and binary forms, with or without %%%%%
%%%%%	modification, are permitted provided that the following conditions %%%%%
%%%%%	are met:														   %%%%%
%%%%%																	   %%%%%
%%%%%	Redistributions of source code must retain the above copyright	   %%%%%
%%%%%	notice, this list of conditions and the following disclaimer.	   %%%%%
%%%%%																	   %%%%%
%%%%%	Redistributions in binary form must reproduce the above copyright  %%%%%
%%%%%	notice, this list of conditions and the following disclaimer in	   %%%%%
%%%%%	the documentation and/or other materials provided with the		   %%%%%
%%%%%	distribution.													   %%%%%
%%%%%																	   %%%%%
%%%%%	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDER AND			   %%%%%
%%%%%	CONTRIBUTOR "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,		   %%%%%
%%%%%	INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF		   %%%%%
%%%%%	MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE		   %%%%%
%%%%%	DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE	   %%%%%
%%%%%	LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,   %%%%%
%%%%%	OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,		   %%%%%
%%%%%	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,	   %%%%%
%%%%%	OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON		   %%%%%
%%%%%	ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,	   %%%%%
%%%%%	OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY	   %%%%%
%%%%%	OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE			   %%%%%
%%%%%	POSSIBILITY OF SUCH DAMAGE. 									   %%%%%
%%%%%																	   %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
start() ->
	io:format("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%                                                                     %%%%%
%%%%%                                SiSSDA                               %%%%%
%%%%%                                                                     %%%%%
%%%%%                                 v ~p                             %%%%%
%%%%%                                                                     %%%%%
%%%%%                                                                     %%%%%
%%%%%                  Welcome to the Simulator for                       %%%%%
%%%%%             Self-Stabilizing Distributed Algorithms                 %%%%%
%%%%%                                                                     %%%%%
%%%%%                              CLIENT                                 %%%%%
%%%%%                                                                     %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n",[?version]),
	Phase = init,
	Name = unset,
	Algorithm = unset,
	Data = unset,
	Read_Register = [],
	Write_Register = [],
	Counter = 0,
	register(client, spawn(client, client, [Phase, Name, Algorithm, Data, Read_Register, Write_Register, Counter])).

start(Name) ->
	register(client, spawn(client, client, [phase_6, Name, unset, unset, unset, unset, 0])).

client(Phase, Name, Algorithm, Data, Read_Register, Write_Register, Counter)->
	if
		Phase == init->
			? server ! {connect, self()},
			receive
				{success, New_Name, New_Algorithm} ->
					io:format("%%%%% Connected successfully. This node has role of node ~p~n",[New_Name])
			end,
			New_Phase = phase_6,
			client(New_Phase, New_Name, New_Algorithm, Data, Read_Register, Write_Register, Counter);
		Phase == phase_0->
			?server ! {ready, Name},
			New_Phase = phase_2,
			client(New_Phase, Name, Algorithm, Data, Read_Register, Write_Register, Counter);
		Phase == phase_2 ->
			receive
				{node_fault, New_Write_Register} ->
					New_Counter = Counter + 1,
					New_Phase = phase_4;
				{grant, New_Write_Register} ->
					New_Counter = Counter + 1,
					New_Phase = phase_3;
				idle ->
					New_Counter = Counter,
					New_Write_Register = Write_Register,
					New_Phase = phase_4;
				kill ->
					New_Phase = kill,
					?server ! {killed, Name},
					New_Write_Register = Write_Register,
					New_Counter = Counter,
					io:format("%%%%% GOING DOWN DUE TO USER INTERRUPTION!                                %%%%%~n")
			end,
			client(New_Phase, Name, Algorithm, Data, Read_Register, New_Write_Register, New_Counter);
		Phase == phase_3 ->
			[First| Rest] = Write_Register,
			if
				is_pid(First) ->
					First ! {request, self()},
					receive
						{Node, Answer} ->
							if
								?verbose == true; ?verbose == client ->
									io:format("%%%%% ASKED NODE ~p~n", [Node]);
								true ->
									ok
							end,
							Elem = get_elem(Node, Data),
							{_, _, _, _, _, Stable, _} = Elem,
							if
								Stable == Answer ->
									New_Read_Register = lists:append(Read_Register, [{true, Answer}]);
								true ->
									New_Read_Register = lists:append(Read_Register, [{false, Answer}])
							end
					after 5 ->
						New_Read_Register = lists:append(Read_Register, [{false, [x]}])
					end;
				true ->
					New_Read_Register = lists:append(Read_Register, [{false, First}])
			end,
			Length = length(Rest),
			if
				Length == 0 ->
					New_Phase = phase_3b;
				true ->
					New_Phase = phase_3
			end,
			client(New_Phase, Name, Algorithm, Data, New_Read_Register, Rest, Counter);
		Phase == phase_3b ->
			New_Write_Register = client_algorithm:start(Algorithm, Name, Read_Register, Data),
			New_Phase = phase_4,
			client(New_Phase, Name, Algorithm, Data, [], New_Write_Register, Counter);
		Phase == phase_4 ->
			?server ! {Name, Write_Register},
			New_Phase = phase_6,
			if
				?verbose == true; ?verbose == client ->
					io:format("%%%%% NAME: ~p REGISTER: ~p~n", [Name, Write_Register]);
				true ->
					ok
			end,
			client(New_Phase, Name, Algorithm, Data, [], Write_Register, Counter);
		Phase == phase_6 ->
			receive
				kill ->
					New_Phase = kill,
					?server ! {killed, Name},
					New_Data = Data,
					New_Algorithm = Algorithm,
					New_Write_Register = [];
				{request, PID} ->
					New_Phase = Phase,
					New_Data = Data,
					New_Algorithm = Algorithm,
					New_Elem = get_elem(Name, Data),
					{_, _, _, _, New_Write_Register, _, _} = New_Elem,
					PID ! {Name, New_Write_Register};
				{update, New_Data, New_Algorithm} ->
					New_Phase = phase_0,
					New_Elem = get_elem(Name, New_Data),
					{_, _, _, _, New_Write_Register, _, _} = New_Elem
			end,
			client(New_Phase, Name, New_Algorithm, New_Data, [], New_Write_Register, Counter);
		Phase == kill ->
			io:format("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%% Executed ~p steps
%%%%% Client reached legal finish                                         %%%%%
%%%%% Initiating shutdown-sequence                                        %%%%%
%%%%% GOOD BYE                                                            %%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~n", [Counter]),
			exit(normal)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%         NILS' LITTLE HELPER FUNCTIONS         %%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
get_elem(Name, Data)->
	[First| Rest] = Data,
	{Node, _, _, _, _, _, _} = First,
	if
		Node == Name ->
			First;
		true ->
			get_elem(Name, Rest)
	end.
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%